package org.emulinker.kaillera.pico

import kotlinx.datetime.Instant

/** Constants inserted at compile time. */
object CompiledFlags {
  const val DEBUG_BUILD: Boolean = false

  const val PROJECT_NAME: String = "EmuLinker-K"

  const val PROJECT_VERSION: String = "0.15.0"

  const val PROJECT_URL: String = "https://github.com/hopskipnfall/EmuLinker-K"

  val BUILD_DATE: Instant = Instant.fromEpochSeconds(1738570220)

  const val USE_BYTEREADPACKET_INSTEAD_OF_BYTEBUFFER: Boolean = false

  /** Indicates a build still in development (and lacking a unique version number). */
  const val PRERELEASE_BUILD: Boolean = false
}
